#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <mpi.h>

int main(int argc, char *argv[]) {
	int ret, size, myrank, nkeys, flag;
	char key[MPI_MAX_INFO_KEY], value[MPI_MAX_INFO_VAL];

	MPI_File fh;
	MPI_Status s;
	MPI_Request r;
	MPI_Info info_used;

	MPI_Init(&argc, &argv);

	MPI_Comm_size(MPI_COMM_WORLD, &size);
	MPI_Comm_rank(MPI_COMM_WORLD, &myrank);

	// Open the file
	ret = MPI_File_open(MPI_COMM_SELF, "get-all-hints.out", MPI_MODE_CREATE|MPI_MODE_RDWR, MPI_INFO_NULL, &fh);

	// Get the info object associated with the file handle
	MPI_File_get_info(fh, &info_used);

	if (myrank == 0) {
		// Get the number of defined keys
		MPI_Info_get_nkeys(info_used, &nkeys);

		printf("there are %d hints set:\n", nkeys);

		for (int i = 0; i < nkeys; i++) {
			// We need to have the key to access its value
			MPI_Info_get_nthkey(info_used, i, key);
			// Now we can get the key value
			MPI_Info_get(info_used, key, MPI_MAX_INFO_VAL - 1, value, &flag);

			printf("  %s: %s (%s)\n", key, value, flag ? "true" : "false");
		}
	}

	MPI_Barrier(MPI_COMM_WORLD);

	// Close the file
	MPI_File_close(&fh);

	MPI_Finalize();

	return 0;
}
